#!/usr/bin/env python3
"""
Wrapper to run .pyc file
"""
import runpy
import sys
import os

def run_pyc(pyc_file, *args):
    """Run a .pyc file with arguments"""
    if not os.path.exists(pyc_file):
        print(f"Error: {pyc_file} not found")
        sys.exit(1)
    
    # Set sys.argv to include the script name and arguments
    sys.argv = [pyc_file] + list(args)
    
    # Load and run the compiled file
    try:
        # Use runpy to execute the pyc file
        runpy.run_path(pyc_file, run_name='__main__')
    except Exception as e:
        print(f"Error running {pyc_file}: {e}")
        import traceback
        traceback.print_exc()
        sys.exit(1)

if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("Usage: run_pyc.py <pyc_file> [args...]")
        sys.exit(1)
    
    pyc_file = sys.argv[1]
    args = sys.argv[2:]
    run_pyc(pyc_file, *args)

